﻿using System;
using System.Globalization;
using System.IO;
using System.Reflection;
using System.Windows.Forms;
using Psion.RFID.HF;

namespace HF_Demo
{
    public sealed partial class AboutForm : Form
    {
        private StreamWriter _rdFileStream; //Used to retrive the versions of app/reader/driver

        /// <summary>
        /// Initializes a new instance of the <see cref="AboutForm"/> class.
        /// </summary>
        /// <param name="reader">The reader instance.</param>
        public AboutForm(Reader reader)
        {
            InitializeComponent();

            if (!Device.IsWM) mainMenu1.Dispose();

            Height = Screen.PrimaryScreen.WorkingArea.Height;

            // Load Reader Info
            lbl_rdrFirmwInfo.Text = "Firmware Vers.: " + reader.GetVersion();

            // Load RFID driver version
            lbl_Module.Text = "Module: " + RFIDDriverHelpers.GetRFIDModuleReference();
            lbl_DriverVersion.Text = "Driver Vers.: " + RFIDDriverHelpers.GetRFIDDriverVersion();
        }

        /// <summary>
        /// Handles the Load event of the AboutForm control.
        /// </summary>
        /// <param name="sender">The source of the event.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        private void AboutFormLoad(object sender, EventArgs e)
        {
            lbl_vers.Text = "Version: " + Assembly.GetExecutingAssembly().GetName().Version.Major.ToString(CultureInfo.InvariantCulture)
                            + "." +
                            Assembly.GetExecutingAssembly().GetName().Version.Minor.ToString(CultureInfo.InvariantCulture);

            lbl_AppName.Text = Assembly.GetExecutingAssembly().GetName().Name;
        }

        /// <summary>
        /// Handles the Click event of the menuItem1 control.
        /// </summary>
        /// <param name="sender">The source of the event.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        private void MenuItem1Click(object sender, EventArgs e)
        {
            Close();
        }

        /// <summary>
        /// Handles the Click event of the bt_save control.
        /// </summary>
        /// <param name="sender">The source of the event.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        private void BtSaveClick(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                //retrieve file name and file directory
                //save the data in the listview
                try
                {
                    _rdFileStream = new StreamWriter(saveFileDialog1.FileName + ".txt", true);

                    _rdFileStream.Flush();
                    _rdFileStream.Write(DateTime.Now);
                    _rdFileStream.WriteLine();
                    // Save Demo application Info
                    _rdFileStream.WriteLine("** DEMO APPLICATION INFO");
                    _rdFileStream.Write(lbl_AppName.Text);
                    _rdFileStream.WriteLine();
                    _rdFileStream.Write(lbl_vers.Text);
                    _rdFileStream.WriteLine();

                    // Save Reader Info
                    _rdFileStream.WriteLine("** READER INFO");
                    _rdFileStream.Write(lbl_rdrFirmwInfo.Text);
                    _rdFileStream.WriteLine();

                    // Save Driver Info
                    _rdFileStream.WriteLine("** RFID DRIVER INFO");
                    _rdFileStream.Write(lbl_Module.Text);
                    _rdFileStream.WriteLine();                    
                    _rdFileStream.Write(lbl_DriverVersion.Text);
                    _rdFileStream.WriteLine();

                    _rdFileStream.Flush();
                    _rdFileStream.Close();
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message);
                }
            }
        }
    }
}